/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning;

import cz.insophy.inplan.planning.PlanningCanceledEvent;
import cz.insophy.inplan.planning.PlanningFinishedEvent;
import cz.insophy.inplan.planning.PlanningListener;
import cz.insophy.inplan.planning.PlanningProgressEvent;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingListener
implements PlanningListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingListener.class);
    private static final long DEFAULT_INTERVAL = 1000L;
    private final AtomicInteger cnt;
    private final AtomicInteger total;
    private final long start;
    private long lastTime;
    private long lastCnt;
    private final Timer timer;

    public LoggingListener() {
        this(1000L);
    }

    public LoggingListener(long intervalMs) {
        this.lastTime = this.start = System.currentTimeMillis();
        this.lastCnt = 0L;
        this.cnt = new AtomicInteger();
        this.total = new AtomicInteger();
        this.timer = new Timer("planning progress");
        this.timer.scheduleAtFixedRate((TimerTask)new LogTask(), intervalMs, intervalMs);
    }

    @Override
    public void onProgress(PlanningProgressEvent e) {
        this.cnt.set(e.getUnit());
        this.total.set(e.getUnitCount());
    }

    @Override
    public void onCancel(PlanningCanceledEvent e) {
        this.timer.cancel();
        this.log();
        log.info("Planning cancelled.");
    }

    @Override
    public void onFinish(PlanningFinishedEvent e) {
        this.timer.cancel();
        this.cnt.set(e.getUnit());
        this.total.set(e.getUnitCount());
        this.log();
        log.info("Planning finished.");
    }

    private void log() {
        long now = System.currentTimeMillis();
        int c = this.cnt.get();
        int t = this.total.get();
        double ratio = (double)c / (double)t;
        double ops = now - this.lastTime > 0L ? (double)((long)c - this.lastCnt) / (double)(now - this.lastTime) * 1000.0 : 0.0;
        Date expectedFinish = new Date((long)((double)(now - this.start) / ratio) + this.start);
        if (log.isInfoEnabled()) {
            log.info(String.format("%d/%d (%3.3f%%) OPS: %6.2f EFT: %s", c, t, ratio * 100.0, ops, expectedFinish));
        }
        this.lastCnt = c;
        this.lastTime = now;
    }

    private class LogTask
    extends TimerTask {
        private LogTask() {
        }

        @Override
        public void run() {
            LoggingListener.this.log();
        }
    }
}

